# Computer vision technologies for safety science and management in construction: A critical review and future research directions

Brian H.W. Guoa\*, Yang Zoub, Yihai FangC, Yang Miang Gohd, Patrick X.W. Zou e,f,\*

aDeptofCivil&NaturalResources Enginering,UniversityofCnterbury69CreykeRoad,Christchurch840,Newealand   
bDeptofCidoli   
DeptofCivilenshesityealk   
fetyd   
Singapore   
EngineringseheefrstruceiastfutiogaUesityi   
fSchooloftiii

# ARTICLEINFO

# ABSTRACT

Keywords:   
Computer vision   
Construction health and safety   
Safety science   
Safety culture   
Safety Climate,Hazard   
Safety management system   
Digital technologies   
Automation

Recent years have seen growing interests in developing and applying computer vision technologies to solve safety problems in the construction industry.Despite the technological advancements,there is no research that exams the theoretical links between computer vision technology and safety science and management.Thus,the objectives of this paper are to: (1) investigate thecurrnt status of applying computer vision technology to construction safety,(2) examine the links between computer vision applications and key research themes of construction safety, (3)discuss the theoretical challenges of applying computer vision to constructionsafety,and (4)recommend future research directions.A five-step review approach was adopted to search and analyze peerreviewed academic journal articles.A three-level computer vision development framework was proposed to categorized computer vision applications in the construction industry.The links between computer vision and three main safety research traditions: safety management system,behavior-based safety program,and safety culture,were discussed.The results suggest thatthe majority of past eforts were focused on object recognition, object tracking,and action recognition,with limited research focused on recognizing unsafe behavior.There are even fewer studies aimed at developing vision-based safety assessment and prediction systems.Based on the review findings,four future research directions are suggested: (1)developand testa behavioral-cues-based safety climate measure,(2)develop safety behaviordatasets,(3)developa formal hazard identificationand assessment model,and (4)develop criteria to evaluate the real impacts of vision-based technologieson safety performance.

# 1．Introduction

Construction is a pillar industry for economic development and employment worldwide.However,construction sites are hazardous in nature.The industry has been one of the top contributors to workplace injuries and fatalities in many countries and regions and therefore construction safety remains as one of the major issues in academic research and in practice.Traditionally research effort has been focused the policy,management, human and cultural issues of safety and there have been critical reviews on these dimensions,for example,human factors in construction safety (Goh et al., 2018; Guo et al., 2015) and strategic safety management (Zou and Sunindijo, 2O15). Effective safety planning and hazard analysis are an essential prerequisite to accident prevention.It has been argued that traditional safety management practices in the construction industry have been manual, timeconsuming, selective,and therefore inefficient and error-prone (Zhang et al., 2015b; Zhang et al., 2013). For example, behavior-based safety (BBS) programs still rely on manual observations to collect unsafe behaviors (Guo et al., 2Ol8).Manual observations and inspections are difficult to cover the whole site and monitor all workers.In addition, paper-based hazard identification systems would impede timely risk communication (Zou et al., 2017a).

The past two decades have seen increasing applications of digital technologies and techniques to help improve construction health and safety management (Guo et al.,2O17a). Examples of digital technologies include,but are not limited to,building information modelling (BIM) (Zou et al., 2O17b), tracking and positioning technologies (Teizer et al., 2013),augmented reality and virtual reality (Wang et al., 2O13),and artificial intelligence (Goh and Guo, 2018; Guo and Goh, 2017). These digital technologies have demonstrated great potential to improve safety planning,hazard management,and safety training and education. Comprehensive summaries of the research in this topic area can be found in (Guo et al., 2017a; Guo et al., 2017b; Li et al., 2018).

Recent years have also seen growing interests in computer vision applications to address the problems in the architecture, engineering, and construction (AEC) industry. Computer vision is an interdisciplinary area that deals with how computers can provide enriched information to support and achieve a high-level understanding of objects and events present in a scene through the analysis of digital images or videos.In recent years,significant research efforts have been made to recognize and track physical elements of engineering projects (e.g.,building elements,tools and equipment,materials,and workers) (Teizer,2015). These efforts have laid a strong foundation for more advanced analysis and assessment, like understanding of construction activities (Seo et al., 2015),productivity assessment (Ibrahim et al.,20o9),quality analysis (Akinci et al., 2Oo6),and real-time structural health of bridges and highways (Fraser et al., 2Oo9). These efforts also made the applications of computer vision to construction health and safety (H&S) possible,and there have been important initiatives to automate H&S processes.For example,Yu et al. (2Ol7) tested the feasibility and accuracy of using computer vision for recognizing three types of unsafe construction behaviors.Han and Lee (2013) proposed a new computer vision-based framework for unsafe action detection and behavior monitoring. Similarly,Fang et al. (2O18d) developed a set of computer vision algorithms to detect workers not wearing harnesses.

Seo et al. (2Ol5) reviewed computer vision techniques for the construction health and safety monitoring.The study was focused on evaluating unsafe behavior from a technical and practical perspective (e. g.,image sensing devices,camera position, viewpoints,etc.).However, safety is a multi-faceted concept and consists of other important dimensions,like safety culture,safety climate,and safety management system (Cooper, 2ooOa,b),and it relates to not only human behavior but also the surrounding environmental conditions such as moving machines,equipment and objects.To the best of the authors'knowledge, there is no research that exams the theoretical links between computer vision technology and safety science and management. To further reap the benefits of computer vision for construction health and safety,it is important to review and evaluate the theoretical links to these key dimensions.

The objectives of this paper are to: (l) investigate the current status of applying computer vision to construction safety,(2) examine the links between computer vision applications and key research themes of construction safety (i.e.,safety management system, behavior-based safety program,and safety culture),(3) discuss the theoretical challenges of applying computer vision to construction safety,and (4) recommend future research directions.

# 2. Methodology

This study applied the systematic review approach adopted by Zhou et al.(2Ol5).The approach consists of five main steps: (1) literature search,(2) literature selection, (3) literature coding,(4) data analysis, and (5) discussion.

# 2.1．Literature search

Scopus is chosen as the database in this study,as it covers a wider journal range (i.e. over 22,ooo journals) than Web of Science and Google Scholar (Falagas et al., 2Oo8). Search attributes and their values are presented in Table1.

Table 1 First search methods.   

<html><body><table><tr><td>Search attributes</td><td>Values used in the search</td></tr><tr><td>Database</td><td>Scopus</td></tr><tr><td>Keywords and Boolean operators</td><td>“Computer vision”OR“object recognition&quot;,OR“object tracking&quot;,OR “action recognition”AND“construction&quot;, OR“health and safety&quot;,OR “risk assessment&quot;, OR</td></tr><tr><td>Search scope</td><td>“hazard&quot;,OR“accident&quot;,OR“incident&quot;,OR“safety&quot; Article title,abstract,or keywords</td></tr><tr><td>Published year</td><td>from all years to present</td></tr><tr><td>Subject area</td><td>Engineering; Computer Science; Social Science;</td></tr><tr><td>Source /Document type Language</td><td>Psychology; Journal article English</td></tr></table></body></html>

As this study focuses only on the applications of computer science to construction health and safety management,only four relevant subject areas were considered,including Engineering,Computer Science,Social Science,and Psychology.Other subject areas like Mathematics,Physics and Astronomy,Material Science,Medicine,Earth,and Planetary Sciences were excluded. Only journal articles were considered in this study. The initial search has resulted in a total of 1711 journal papers.

Following the systematic review approach (Zhou et al.,2015),a secondary search was conducted by picking up journals that are relevant to the construction industry and safety science.Eleven journals were selected to perform the secondary search,including Automation in Construction,Journal of Computing in Civil Engineering,Advanced Engineering Informatics,Journal of Construction Engineering and Management, Journal of Management in Engineering,Accident Analysis and Prevention, Computer-Aided Civil and Infrastructure Engineering, Canadian Journal of Civil Engineering,and Electronic Journal of Information Technology in Construction,and Safety Science.

Keywords and Boolean operators,“computer vision”AND“construction",were implemented to search relevant papers in these journals.The secondary search has identified 893 journal papers.

# 2.2.Literature selection

Note that the secondary search did not focus only on the applications of computer vision to construction health and safety,rather it considered general applications of computer vision to construction.This consideration is based on the fact that vision-based health and safety management largely relies on object recognition and tracking. Including the foundational works can help understand the evolution of computer vision for construction health and safety.A preliminary review was performed to determine if the 893 papers should be kept for in-depth review and analysis based on the following filter criteria:

Table 2 Development levels of computer vision.   

<html><body><table><tr><td colspan="2">Development Level</td><td>Function</td><td>Key research questions</td></tr><tr><td rowspan="2">L1: Detection, recognition,and tracking</td><td>L1.1</td><td>Object detection and recognition</td><td>Is something there? What is the object?</td></tr><tr><td>L1.2</td><td>Object tracking</td><td>Where is the object? Where is the object headed?</td></tr><tr><td rowspan="2">L2:Assessment</td><td>L1.3 L2.1</td><td>Action recognition Object assessment</td><td>What is the object doing? Is the object a hazard?</td></tr><tr><td></td><td></td><td>Is the object in an unsafe or unhealthy state?</td></tr><tr><td rowspan="6">L3:Prediction</td><td rowspan="2">L2.2</td><td>Behavior</td><td>Is the action unsafe or</td></tr><tr><td>assessment</td><td>unhealthy?</td></tr><tr><td rowspan="2">L2.3</td><td>Condition</td><td>Is the working condition</td></tr><tr><td>assessment</td><td>(scenario) unsafe?</td></tr><tr><td rowspan="2">L3.1</td><td>Behavior</td><td>How will the object</td></tr><tr><td>prediction</td><td>behave?</td></tr><tr><td rowspan="2"></td><td rowspan="2">L3.2</td><td>Incident prediction</td><td>Will the next incident</td></tr><tr><td></td><td>occur?</td></tr></table></body></html>

Table 3 Relevant paper number by journals.   

<html><body><table><tr><td>Journal title</td><td>Number of papers</td></tr><tr><td>Automation in Construction</td><td>69</td></tr><tr><td>Journal of Computing in Civil Engineering</td><td>27</td></tr><tr><td>Advanced Engineering Informatics</td><td>23</td></tr><tr><td>Journal of Construction Engineering and Management</td><td>9</td></tr><tr><td>Accident Analysis and Prevention</td><td>8</td></tr><tr><td>Canadian Journal of Civil Engineering</td><td>4</td></tr><tr><td>Computer-Aided Civil and Infrastructure Engineering</td><td>4</td></tr><tr><td>Safety Science</td><td>3</td></tr><tr><td>Electronic Journal Of Information Technology In Construction</td><td>3</td></tr><tr><td>Construction Innovation</td><td>3</td></tr></table></body></html>

(1) Only research articles,technical papers,case study,review papers were kept, while all book reviews,editorials,and conference papers were excluded.   
(2) Articles that only mentioned“computer vision”but do not focus were removed.   
(3) Articles that apply computer vision to the robot, manufacturing, structural assessment, inspection,and defect and crack detection were also excluded,as they do not represent the foundational works for vision-based health and safety management.

As a result,a total of 165 papers were retained for in-depth review and analysis.

# 2.3. Literature coding

All remaining papers were coded according to (1) title,(2) publication year,(3) journal title,(4) country or region (all authors were counted),(5) development level.

Based on the literature review,we classified the development and application of computer vision in the construction industry into three different levels:Ll detection,recognition and tracking,L2 assessment, and L3 prediction.As shown in Table 2,Level 1 can be further decomposed into three sub-levels:Ll.1 object detection and recognition, L1.2 object tracking,and Ll.3 action recognition.These three levels were proposed mainly based on a health and safety perspective,as applications at different levels have different implications on construction

health and safety management.

The three sub-levels ask three key research questions (1) is something there?(2)what is the object?(3) where is the object? and (4) what is the object doing? respectively. Computer vision applications at the Level 2aim to determine if an object isa hazard (i.e.,L2.1 object assessment) and an action is safe or not (i.e.,L2.2 behavior assessment) or assess the risk level of the work conditions which consist of building elements,workers,equipment, tools,and materials (i.e.,L2.3 condition assessment).Key research questions at this level include:(1) is the object a hazard? (2) is the action unsafe or unhealthy? and (3) is the working condition (scenario) unsafe? At Level 3,computer vision techniques are used to predict behavior (i.e.,L3.1 behavior prediction) or generate early warnings of incidents (i.e.,L3.2 incident prediction).Key research questions at this level are:(1) how will the object behave,and (2) will the next incident occur?

# 3.Results

# 3.1． Journal sources

Table 3 presents the distribution of the 153 papers in the 10 journals. Automation in Construction has 69 papers,accounting for almost half $( 4 5 \% )$ of all selected papers. Journal of Computing in Civil Engineering and Advanced Engineering Informatics have 27 and 23 papers,respectively,followed by the Journal of Construction Engineering and Management and Accident Analysis and Prevention.Only $1 1 \%$ of the selected papers were published in the other 5 journals.

# 3.2. Year profile of publications

The earliest relevant paper was published in the Journal of Computing in Civil Engineering in 1997.The paper presented a visionbased interactive control technology to support the operation of bridge paint removal (Moon and Bernold,1997).As shown in Fig. 1, the period between 1997 and 20o7 had seen very few (only10) studies of computer vision for construction.Starting from 2Oo8,the topic of computer vision had received increasing attention since 2Oo8 in the construction industry and safety science and management.Despite the fluctuations between 2oo8 and 2O19, there has been an increasing trend during the period.

![](images/2fc2dfe93c50587291a036771d77eb2127e692b713c1bed231b8238262f69a03.jpg)  
Fig.1.Annual distribution of publications from 1997 to 2019.

# 3.3.Publications distributed by country/region

The selected publications were then coded based on all the authors' affiliation.As shown in Fig.2,authors from the USA wrote about $4 1 \%$ (62 papers) of all papers selected,which are followed by authors from Canada $( 2 4 \% )$ , South Korea $( 1 8 \% )$ , China $( 1 4 \% )$ ,the UK $( 1 1 \% )$ ,Hong Kong $( 1 0 \% )$ ,Australia $( 8 \% )$ ,and Germany $( 5 \% )$ .Authors from other countries and regions were responsible for $1 4 \%$ of the selected papers.

# 3.4. L1: Detection,recognition, and tracking

Construction sites involve various project-related objects (e.g., workers,equipment, tools,and resources) and a wide range of activities (e.g.,earthmoving,lifting and hoisting). Safety risks and hazards are closely related to site objects’physical characteristics,location,moving path,activities,and spatial and temporal relationships between them. Thus,recognizing and tracking site objects of interest and recognizing activities are essential for computer systems to understand the complex scenes of construction and perform a risk assessment and hazard management.

# 3.4.1.L1.1 object detection and recognition

In general,object recognition aims to recognize the objects of interest on site from images and video frames.Object detection and recognition are concerned with the questions: (1) is something there, and (2) what is the object? Based on their recognition cues,the methods can be generally classified into three main categories: (1） geometrybased,(2) appearance-based,and (3) feature-based (Tajeen and Zhu, 2014).Early object recognition studies in the construction industry tended to apply geometry-based and appearance-based methods.For example, Chi and Caldas (2O1la) selected four main geometric and appearance features (i.e.,aspect ratio, height-normalized area size, percentage of occupancy of the bounding box, and average gray-scaled color) to classify mobile heavy equipment and workers.

The period between 2011 and 2016 has seen more applications of visual feature detectors and descriptors to object detection in the construction industry (Azar, 2015; Azar and McCabe, 20l2; Dimitrov and Golparvar-Fard, 2014; Memarzadeh et al.， 2013; Park et al.， 2015; Rezazadeh Azar and McCabe, 2011; Soltani et al., 2016). They include the Scale-Invariant Feature Transform (SIFT) (Lowe,1999), Histogram of Oriented Gradients (HOG) (Dalal and Triggs, 2O05),Haar-like features (Lienhart and Maydt, 2OO2),and the Speeded Up Robust Features (SURF) (Bay et al.,2Oo8). These methods capture a set of local visual features to represent an object.The significant advantage of these methods is that they are robust in partial occlusion due to the fact that they capture scale-illumination- and affine transformation- invariant features (Carr et al., 2012; Tajeen and Zhu, 2014).

Since 2O17,deep learning techniques have become primary object detection and recognition methods. For example, Kim et al. (2017) applied the region-based fully convolutional network (R-FCN) (Dai et al.,2Ol6) as a classifier to recognize heavy equipment on site (e.g., dump truck,excavator,loader,concrete mixer truck,and road roller). The method has achieved a high level of precision and recall rate.In addition,another deep learning technique,Faster R-CNN (region-based convolutional neural networks)，has also gained popularity.For example, it has been utilized to detect non-hardhat-users (Fang et al., 2018b), worker (Fang et al., 2018d; Son et al., 2019), nails and screws (Wang et al., 2O19).The major advantage of Faster R-CNN,compared to R-CNN,is that it is much faster and enables real-time object detection (Ren et al., 2O15). It is also powerful to deal with occlusion (Fang et al., 2018b). Tajeen and Zhu (2Ol4) developed and evaluated a dataset of five classes of construction equipment (excavator,loader,dozer,roller, and backhoe) by using two well-known object recognition methods developed by Torralba et al. (20o4) and Felzenszwalb et al. (2009). Results suggested that the methods demonstrated strengths in different aspects (i.e.,correctness,robustness,and speed).A summary of object detection and recognition studies in the construction industry is presented in Table 4.

Research has been conducted to recognize special “objects",such as workspaces and trades.For example,Luo et al. (2O19) identified four types of workspaces (i.e.,working areas,paths,laydown areas,and rest areas） by integrating object detection,multiple object tracking,action recognition,and reasoning.Due to the temporal and spatial nature of site hazards,vision-based workplace identification can help safety planning. Fang et al. (2O18c) proposed a novel framework to recognize trades by analyzing the dynamic spatiotemporal relevance between workers and non-worker objects.

# 3.4.2. L1.2 object tracking

Object tracking is another important research topic in computer vision.Monitoring workers and equipment is of great importance for site safety.The goal of object tracking is to locate a moving object of interest over time.In general,it consists of detecting the object,creating a unique ID for the object,and tracking the object as it moves around frames ina video.Ina tracking task,objects of interest can be represented by shapes (e.g., skeleton, points,geometric shapes,and contour) and appearances (e.g.,color,edges,and texture).

2D object tracking methods can be classified into three categories: (1) Silhouette (or Contour) tracking,(2) kernel tracking,and (3) Point tracking (Park et al.， 201l; Yilmaz et al. 2006). Silhouette tracking methods represent the object by edges,contours or silhouettes.The goal of Silhouette tracking is to find the object region in each frame based on the representation.Kernel-based trackers compute the motion of the kernel of the object (i.e.,shape and appearance) in each frame.Pointbased methods detect objects that are represented by points in consecutive frames (Yilmaz et al., 2006).

![](images/8d266703dcde4737d38f28baaf900a7b8f3bd91cab0b1201150535de84371806.jpg)  
Fig.2.Geographical distribution of publications.

<html><body><table><tr><td colspan="4">Table4 Object detection and recognition studies in the construction industry.</td></tr><tr><td>Paper</td><td>Object</td><td>Detectors/classifiers</td><td>Performance (correctness)</td></tr><tr><td>Chi and Caldas (2011a)</td><td>Mobile heavy equipment; workers</td><td>Two classifiers: Normal Bayes classfier and Neural network</td><td>Accuracy: 96%</td></tr><tr><td>Rezazadeh Azar and McCabe (2011)</td><td> Dump trucks</td><td>Haar-histogram of oriented gradients (HOG) and Blob-HOG</td><td>Detection: 91%</td></tr><tr><td>Park and Brilakis (2012)</td><td>Worker</td><td>HOG,HSV color histogram, support vector machine (SVM),and k-NN classifier</td><td>Precision: 99.0% Recall: 81.4%</td></tr><tr><td>Azar and McCabe (2012)</td><td>Hydraulic excavators</td><td>HOG, latent support vector machine (SVM) and, spatial-temporal reasoning</td><td>Accuracy: 95.2%</td></tr><tr><td>Memarzadeh et al. (2013)</td><td>Standing workers; excavators; dump trucks</td><td>Histograms of Oriented Gradients and Colors (HOG + C),and binary SVM</td><td>Accuracy: 98.83% (standing workers),82.10% (excavators), and 84.88% (dump trucks)</td></tr><tr><td>Dimitrov and Golparvar- Fard (2014)</td><td>Construction materials</td><td>Hue-Saturation-Value (HSV) color values，, kernel Support Vector Machine</td><td>Accuracy: 97.1%</td></tr><tr><td>Azar (2015)</td><td>Dump trucks; excavators</td><td>HOG, Linear SVM, and AprilTag</td><td>Precision: 100%, Recall: 64.6% (excavators) and 77.1% (dump trucks)</td></tr><tr><td>Park et al. (2015) Kim et al. (2016)</td><td>Human body; hardhat Construction site</td><td>HOG and SVM Data-driven scene</td><td>Precision: 99.6% Recall: 96.8% Recognition:</td></tr><tr><td>Soltani et al. (2016)</td><td>objects (e.g, loader, dust, crane, etc.) Excavators</td><td>parsing method HOG, 3D model with</td><td>81.48% Recall: 98%;</td></tr><tr><td>Kim et al. (2017)</td><td>Dump truck, excavator,</td><td>16 backgrounds Region-based fully convolutional</td><td>Accuracy: 75% Average Precision: 96.33%，</td></tr><tr><td>Hamledari </td><td>loader, concrete mixer truck, and road roller Drywall,</td><td>network (R-FCN) SVM</td><td>Average Recall: 91.94% Precision: from</td></tr><tr><td>et al. (2017) Kim and Kim</td><td>insulation, stud, electrical outlet Concrete mixer</td><td>HOG and SVM</td><td>80.21 to 92%, Recall: from 80.50% to 93.43% Precision:</td></tr><tr><td>(2018) Fang et al.</td><td>truck Non-hardhat-</td><td>Faster R-CNN (region-</td><td>77.27%, Recall: 75.56 Precision: 95.7%,</td></tr><tr><td>(2018b) Fang et al.</td><td>users Worker, safety</td><td>based convolutional neural networks) Faster R-CNN and a</td><td>Recall: 94.9% Precision: 99%,</td></tr><tr><td>(2018d) Kolar et al.</td><td>harness Safety guardrail</td><td>deep CNN Convolutional neural</td><td>Recall: 95% Accuracy: 96.5%</td></tr><tr><td>(2018) Fang et al.</td><td>Excavator,</td><td>network (CNN) Improved Faster</td><td>Accuracy: 91%</td></tr><tr><td>(2018e)</td><td>worker</td><td>Regions with Convolutional Neural Network Features</td><td>(worker), 95% (excavator)</td></tr><tr><td>Mneymneh et al. (2018)</td><td>Worker, hardhat</td><td>(IFaster R-CNN) HOG and SVM</td><td>Human: precision: 98.82%,recall of 86.41%;</td></tr><tr><td></td><td></td><td></td><td>Hardhat: precision: 94.65%, recall of 93.48%</td></tr><tr><td>Son et al. (2019)</td><td>Worker</td><td>Faster R-CNN</td><td>Precision: 96.03%,</td></tr></table></body></html>

Table 4 (continued)   

<html><body><table><tr><td>Paper</td><td>Object</td><td>Detectors/classifiers</td><td>Performance (correctness)</td></tr><tr><td>Wang et al.</td><td>Nails and screws</td><td>Faster R-CNN</td><td>Recall: 98.13% Accuracy: 94.3% Average Precision:</td></tr></table></body></html>

Table 5 summarizes the studies of object tracking in the construction industry. It is evident that construction workers are the main object of interest.Different tracking methods (e.g.，Kernel tracking，Point tracking,and Silhouette tracking) were applied to track workers (Park and Brilakis, 2016; Teizer and Vela, 2009; Yang et al., 201O; Zhu et al., 2016b).Despite these advances,there are a number of significant challenges when tracking construction site resources,including (1) scale variations,(2) occlusions,(3) appearance similarity,(4)abrupt movement, (5) background clutter (Konstantinou et al., 2019; Teizer, 2015). Park et al. (2O11) conducted experiments to compare these 2D vision trackers'effectiveness in tracking construction resources.Results indicated that the kernel-based method was stable and insensitive to illumination conditions,illumination variation,and scale variations and that the point-based method is effective to deal with occlusions.They suggested that overall the kernel-based methods were the most appropriate for tracking construction site resources.In order to address these challenges,Konstantinou et al.(2Ol9) proposed a novel 2D tracking method that consists of three models,including an adaptive model,a prediction model,and an appearance model, to track multiple workers in complex environments (e.g.,occlusions,illumination variations, congested environment,and abrupt changes of workers’motion).

2D tracking results are not always adequate for comprehensive construction-related assessment and analysis (e.g., productivity or safety assessment) and hence the attempts in acquiring a 3D position,direction,and speed of construction objects are important.Brilakis et al. (2011）proposed a vision-based tracking method that provides 3D positions of wheel loaders and trucks by correlating two camera views. Konstantinou and Brilakis (2O18) adopted a motion-based matching method in conjunction with geometric restrictions.In addition, Lee and Park (2O19) developed a framework that can track multiple workers'3D positions based on stereo vision.

# 3.4.3. L1.3 action recognition

Human action recognition is an active research topic in the computer vision community (Vrigkas etal.,2Ol5). It aims to recognize the actions of an agent of interest. The goal of action recognition is to correctly classify input data (e.g.,video sequences or still images) into the underlying action category. Research has suggested that most of the construction accidents are caused by human errors and human-equipment interactions.Thus,an effective vision-based safety monitoring system requires to recognize not only human actions but also equipment operations.Edwards et al.(2Ol6) classified human behavior into five categories with different levels of abstraction and complexity: (1) pose, (2) gesture,(3)action,(4) interaction (human-to-human and human-toobject),and (5)activity.

Human action recognition methods can be grouped into two main categories: (1) unimodal and (2) multimodal methods (Vrigkas et al., 2015).Unimodal methods use the data of a single modality to represent actions and they can be further categorized into four methods (1) space-time,(2) stochastic,(3) rule-based,and(4) shape-based methods. In contrast,multimodal methods integrate features obtained from different sources (e.g.,visual and audio data) and they can be classified into three categories:(1） affective,(2） behavioral,and (3) social networking methods.It is beyond the scope of this paper to introduce each method. Details can be found in work by Vrigkas et al. (2015).

Table 5 Object tracking studies in the construction industry.   

<html><body><table><tr><td>Paper</td><td>Object tracked</td><td>Description</td><td>Tracking method applied</td></tr><tr><td>Teizer and Vela (2009)</td><td>Workers</td><td>Compared four tracking techniques: Density Mean-shift, Bayesian Segmentation,Active Contours,and Graph- cuts, The Bayesian method with temporal averaging performed</td><td>Kernel tracking</td></tr><tr><td>Chi et al. (2009) Yang et al. (2010) Brilakis et al. (2011)</td><td>Construction resources Multiple workers</td><td>the best overall. Probabilistic Hausdorff image matching Kernel covariance tracking Compared the three</td><td>Silhouette tracking Kernel tracking Kernel</td></tr><tr><td></td><td>Project-related entities (e.g. wheel loaders and trucks)</td><td>categories of 2D vision-based tracking methods -contour- based, kerel-based, and point-based methods.</td><td>Silhouette tracking,and Point tracking tracking,</td></tr><tr><td>Park et al. (2011)</td><td>Construction site resources</td><td>Compared the three categories of 2D vision-based tracking methods -contour- based, kernel-based, and point-based</td><td>Kernel Silhouette tracking, and tracking, Point tracking</td></tr><tr><td>Teizer (2015)</td><td>Temporary resources on infrastructure construction sites</td><td>methods. Reviewed the status quo and open challenges in vision- based tracking of temporary resources on infrastructure</td><td>/</td></tr><tr><td>Park and Brilakis (2016)</td><td>Workers</td><td>construction sites Eigen-images and particle filtering (Ross et al., 2008)</td><td>Point tracking and Kernel tracking</td></tr><tr><td>Yuan et al. (2016)</td><td>Excavator</td><td>Optical flow estimation and 3D triangulation</td><td></td></tr><tr><td>Zhu et al. (2016b) Kim and Chi (2017)</td><td>Workers, roller, truck,and dozer Construction equipment</td><td>Particle filtering A median-flow algorithm (Kalal et al., 2011)and a pyramidal Lucas-Kanade</td><td>Point tracking Point tracking</td></tr><tr><td>Lee and Park (2019) Konstantinou et al. (2019)</td><td>Workers Multiple workers</td><td>algorithm (Bouguet, 2001) 3D tracking based on stereo vision Track multiple workers in complex environments (e.g., occlusions, illumination variations,congested</td><td>3D tracking /</td></tr></table></body></html>

Table 6 lists previous human and equipment action recognition studies in the construction industry sorted by year.Construction involves a wide range of heavy equipment (e.g., tower crane, dump trucks and excavators,etc.).Thus,recognizing equipment operations has also attracted much attention from researchers.

Since 20o7,attention has been paid on recognizing basic equipment operations, such as hydraulic excavator actions (Zou and Kim,2Oo7) and excavator and truck actions (Golparvar-Fard et al., 2Ol3). The information of basic actions is of less usefulness to productivity analysis and schedule assessment. Thus,in recent years,researchers have made efforts to recognize actions with a higher level of abstraction and complexity.For example,earthmoving activities involve the interactions between excavators and dump trucks.Efforts were made to recognize the interactions (Bigler et al., 2017； Kim and Chi, 2019; Rezazadeh Azar, 2017; Rezazadeh Azar et al., 2012). Event/Activity classification usually requires more information/features.For example, liner-lowering events were recognized based on the tunnel concrete liner recognition and descending trajectories of the liner (Ranaweera et al., 2012).

Table 6 Action recognition studies in the construction industry.   

<html><body><table><tr><td>Study</td><td>Year</td><td>Action type</td><td>Level of action</td></tr><tr><td>Zou and Kim (2007)</td><td>2007</td><td>Hydraulic excavator actions</td><td>Action</td></tr><tr><td>Gong and Caldas (2009)</td><td>2010</td><td>Concrete column pour</td><td>Activity</td></tr><tr><td>Gong et al. (2011)</td><td>2011</td><td>Both worker actions traveling, transporting, bending down, aligning,and nailing) and equipment actions (relocating,</td><td>Action</td></tr><tr><td>Bai et al. (2011)</td><td>2012</td><td>excavating,and swing) Worker back bending</td><td>Pose</td></tr><tr><td>Ray and Teizer (2012)</td><td>2012</td><td>Worker standing,bending,sitting, crawling</td><td>Pose</td></tr><tr><td>Han et al. (2013)</td><td>2013</td><td>Reaching too far in ladder climbing</td><td>Pose</td></tr><tr><td>Golparvar-Fard</td><td>2013</td><td>Excavator and truck actions (digging, hauling,dumping,</td><td>Action</td></tr><tr><td>et al. (2013) Azar et al. (2012)</td><td>2013</td><td>swinging, etc.) Excavators and dump trucks</td><td>Object-to-</td></tr><tr><td></td><td></td><td>actions during dirt loading</td><td>object interaction</td></tr><tr><td>Ranaweera et al. (2012)</td><td>2013</td><td>Liner-lowering activity in tunnel construction</td><td>activity</td></tr><tr><td>Yang et al. (2012)</td><td>2014</td><td>Tower crane activity (loading, lifting,and unloading materials) picking up,holding,walking,</td><td>Activity</td></tr><tr><td>Khosrowpour et al. (2014)</td><td>2014</td><td>putting down, measuring and cutting,breaking the gypsum</td><td>Action</td></tr><tr><td>Han et al. (2014)</td><td>2014</td><td>board,and idling Safe and unsafe actions</td><td>Action</td></tr><tr><td>Yang et al. (2016)</td><td>2016</td><td>lay brick, transporting,cut plate, drilling, tie rebar</td><td>Action</td></tr><tr><td> Buigler et al.</td><td>2017</td><td>Earthmoving operations</td><td>Object-to- object</td></tr><tr><td>(2017) Yu et al. (2017)</td><td>2017</td><td>Ladder climbing,leaning on</td><td>interaction Pose</td></tr><tr><td></td><td></td><td>handrails,dumping waste from height</td><td></td></tr><tr><td>Yan et al. (2017) Azar (2015)</td><td>2017 2017</td><td>Ergonomic postures Earthwork operation (e.g.,</td><td>Pose Object-to-</td></tr><tr><td></td><td></td><td>backfill) 17 types of construction activities</td><td>object interaction Activity and</td></tr><tr><td>Luo et al. (2018b)</td><td></td><td>and actions (e.g., placing concrete and fixing rebar)</td><td>action</td></tr><tr><td>Zhang et al. (2018)</td><td>2018</td><td>Both arms below, etc.</td><td>Pose</td></tr><tr><td>Soltani et al. (2018)</td><td>2018</td><td>Excavator pose</td><td>Pose</td></tr><tr><td>Kim et al. (2018a)</td><td>2018</td><td>Mixed activities of construction equipment</td><td>Activity</td></tr><tr><td>Kim et al. (2018b)</td><td>2018</td><td>Earthmoving operations</td><td>Object-to- object interaction</td></tr><tr><td>Ding et al. (2018)</td><td>2018</td><td>Normal ladder and abnormal ladder climbing</td><td>Action</td></tr><tr><td>Luo et al. (2018a)</td><td>2018</td><td>Steel bending,transporting, walking</td><td>Action</td></tr><tr><td>Luo et al. (2018c)</td><td>2018</td><td>16 classes of activities of rebar and formwork</td><td>Activity and action</td></tr><tr><td>Fang et al. (2018a)</td><td>2018</td><td>Aerial operation scenario</td><td>Human-object interactions</td></tr><tr><td>Xu and Yoon (2019)</td><td>2019</td><td>Excavator manipulator pose</td><td>Pose</td></tr><tr><td>Kim and Chi (2019)</td><td>2019</td><td>excavator earthmoving</td><td>Activity</td></tr><tr><td>Liang et al. (2019)</td><td>2019</td><td>Excavator manipulator pose</td><td>Pose</td></tr></table></body></html>

In addition,Kim et al.(2O18b) developed a vision-based activity recognition framework that can recognize the interaction between excavators and dump trucks in earthmoving operations.They classified equipment behavior into low-level individual actions (e.g.,load soil, travel to dumping area,and dump soil) and high-level activities (idle, travel,and work).High-level activities were recognized by interpreting the interactions based on a knowledge-based system that evaluates individual actions and proximity between excavators and dump trucks. Interaction analysis was conducted based on co-existence and proximity of equipment and its action consistency.

Early efforts of vision-based human action recognition were mainly focused on the pose and basic action (e.g., traveling, bending down, standing, sitting, and crawling) (Bai et al., 2O11; Gong et al., 2011; Ray and Teizer, 2Ol2).Inter-class similarity and intra-class variance are major challenges faced with vision-based human action recognition researchers (Gong et al., 2Ol1). In construction, the inter-class similarity of different worker actions may be big,while the intra-class variance of the same action might also be significant.

Action recognition can also be broken down into two processes: action detection and action recognition.For example,Yu et al. (2017) detected unsafe behaviors (i.e.,is there an unsafe behavior?) by determining the value ranges of key joint parameters based on the theory of human skeleton model,while recognized unsafe behaviors (i.e.,which type of unsafe behavior) by selecting and measuring the parameters that can distinguish one behavior with the others.Luo et al.(2Ol8b) proposed a two-step method to recognize diverse construction activities in still site images.It first detects construction-related objects using Faster R-CNN.The information was further processed based on semantic relevance rules to classify construction activities.

It is worth noting that the main purpose of these studies is to facilitate productivity analysis and optimization,rather than safety assessment and monitoring.Despite this,equipment operation recognition forms an essential part of vision-based safety assessment and monitoring system,as many site hazards are equipment-related.

# 3.5.L2: Assessment

High-level vision-based assessment is usually based on object detection and recognition,object tracking,and action recognition. For example, Fang et al. (2O18c) demonstrated that detecting non-certified work on site was based on a combination of object detection,object tracking,face recognition,and trade recognition techniques.Assessment can be data-driven (e.g.，using machine learning techniques), knowledge-driven (e.g.，using rules),and model-driven (e.g.,actual against planned schedule).It can be focused on objects,behaviors of objects,and conditions of the construction site.

Table 7 presents vision-based assessment studies in the construction industry. It shows that past efforts were focused on vision-based productivity and safety assessment.In general, productivity analysis was performed based on object recognition, tracking,and/or action recognition. For example,Gong and Caldas(2O11） developed a prototype system which uses objects'(e.g.,column,slab,scaffold,bobcat loader, etc.）spatial positions and moving trajectories as inputs to determine schedule progress by comparing the inputs against defined spatial regions.Bai et al.(2Ol1） applied artificial neural networks (ANN) to determine if the working status is effective or not.In addition,Turkan et al.(2Ol2） combined computer vision and building information modeling (BIM) technologies to assess productivity by measuring earned

Table 7 Vision-based productivity and safety assessment studies in the construction industry.   

<html><body><table><tr><td>Study</td><td>Assessment type</td><td>Assessment method</td></tr><tr><td>Ibrahim et al. (2009)</td><td>Productivity assessment</td><td>Model-driven</td></tr><tr><td>Gong and Caldas (2011)</td><td>Productivity assessment</td><td>Knowledge-driven</td></tr><tr><td>Chi and Caldas (2011b)</td><td>Safety assessment</td><td>Knowledge-driven</td></tr><tr><td>Bai et al. (2011)</td><td>Productivity assessment</td><td>Data-driven</td></tr><tr><td>Turkan et al. (2012)</td><td>Productivity assessment</td><td>Model-driven</td></tr><tr><td>Seo et al. (2014)</td><td>Ergonomic assessment</td><td>Data-driven</td></tr><tr><td>Han et al. (2014)</td><td>Safety assessment</td><td>Data-driven</td></tr><tr><td>Liu et al. (2015)</td><td>Productivity assessment</td><td>Knowledge-driven</td></tr><tr><td>Kim et al. (2015)</td><td>Safety assessment</td><td>Knowledge-driven</td></tr><tr><td>Bigler et al. (2017)</td><td>Productivity assessment</td><td>Data-driven</td></tr><tr><td>Kropp et al. (2018)</td><td>Productivity assessment</td><td>Model-driven</td></tr><tr><td>Chen et al. (2019)</td><td>Safety assessment</td><td>Model-driven</td></tr><tr><td>Kim et al. (2019a)</td><td>Safety assessment</td><td>Model-driven</td></tr><tr><td>Kim et al. (2019b)</td><td>Productivity assessment</td><td>Data-driven</td></tr></table></body></html>

value (EV).

From a health and safety perspective,object assessment refers to assessing if the object of interest is a hazard or not,or if the object is in an unsafe and unhealthy state.Vision-based site condition assessment is a higher level of application than object recognition and tracking and action recognition.The basic information extracted from object recognition and tracking and action recognition are often further assessed based on rule-based or ontology-based knowledge models.For example, Chi and Caldas (2O11b) demonstrated how the data acquired from object recognition and tracking could be utilized for automatic safety assessment.They designed safetyrules to detect three types of safety violation (i.e.，speed limit,dangerous access,and close proximity). Similarly,Kim et al.(2015) developed an on-site safety assessment system which incorporates two modules: vision processing module (VPM) and safety assessment module (SAM).VPM collects the spatial information about workers and equipment using computer vision, while SAM assesses the safety levels using IF-THEN rules and fuzzy inference. Ray and Teizer (2Ol2) applied to a linear discriminant analysis method to classify worker posture and then used predefined rules to determine if the posture is ergonomic or not. Chen et al. (2Ol9) evaluated workers' safety risk based on the fusion of position and posture information. However, the way that the authors measured the risk level without linking it to a specific hazard and the construction context is confusing and arbitrary.Kim et al.(2O19a) used a camera-mounted unmanned aerial vehicle to evaluate the safetyrisk of struck-by hazard based on proximity measurement and monitoring.The system will visualize the hazard when a worker is close to mobile equipment.However,visionbased safety assessment system which is only based on proximity tends to generate false alarms.For example,it is safe when a worker is close to an excavator that is not operating.It would be more reliable if reasoning and inference are based on a combination of proximity measurement and action recognition.

# 3.6.L3:Prediction

From a proactive safety management perspective,being able to predict a dangerous situation before it occurs is far more important than recognizing it thereafter.This task is referred to as vision-based prediction where computer vision techniques anticipate “when will the object(s) do what".Most of the existing action recognition methods,as reviewed in Section 3.4.3,were developed and applied to recognize complete actions.They are unable to recognize unfinished action videos and therefore cannot be used for action prediction.

The literature review reveals that applications of computer vision to predict the motion of workers and mobile equipment in the construction industry have been rather limited.As an early attempt,Zhu et al. (2016a) used Kalman filters for predicting movements of workers and mobile equipment on the construction site in order to prevent,potential struck-by accidents.This method involves two main steps: (1) estimate 3D positions of workers and mobile equipment through visual detection, tracking,and triangulation and (2) feed the estimated positions into a Kalman filter to predict the positions of workers and equipment.The performance of the Kalman filter can be further enhanced by learning from past prediction.

Despite the scarcity of relevant studies in the construction domain, action prediction is gaining increased attention in the computer vision community.For example,Ryoo (2O11） presented a human activity prediction method,a combination of integral bag-of-words and dynamic bag-of-words,for activity prediction.Lan et al. (2O14) proposed a new representation,hierarchical movements,to describe human movements at multiple levels of granularities and developed a max-margin learning framework for action prediction. Koppula and Saxena (2O16) used an anticipatory temporal conditional random field (ATCRF) to anticipate human activities. The study obtained an activity anticipation accuracy of $8 4 . 1 \%$ $7 4 . 4 \%$ ，and $6 2 . 2 \%$ for an anticipation time of 1,3,and $_ { 1 0 s }$ respectively.It is clear that the method is less powerful to predict human activities fora long time horizon.To address this problem,Farha et al. (2018) proposed two novel approaches to improve prediction duration. The first approach is based on a recurrent neural network (RNN),while the second approach builds on a convolutional neural network (CNN). The work can predict video content of up to several minutes'length.It is beyond the scope of this paper to review human activity prediction studies in the computer vision community.Readers are referred to a comprehensive survey by Trong et al. (2017).

# 4.Discussion

In a comprehensive survey, Jin et al. (2Ol9) identified five main research topics within the theme of construction safety,including (1) safety climate and safety culture,(2) information and communication technology (ICT) in safety management,(3) workers'safety perception and behavior,(4) safety management system,and (5) hazard identification,accident causation,and risk management in safety. Considering the fact that computer vision represents an ICT and that hazard identification and risk management can be integrated into safety management systems,this section discusses three main aspects to demonstrate how computer vision technologies may be applied in improving construction safety management. These are (1） vision-based safety management system,(2) vision-based behavior-based safety (BBS) program,and (3) vision-based safety culture sensing system.

# 4.1. Vision-based safety management system

A safety management system (SMS) integrates a combination of activities and functions to identify hazards and manage risks in the workplace (Guo and Yiu, 2O16). Common safety management activities in the construction industry include,but are not limited to,health and safety policy，safety planning,hazard management,workplace inspections,incident reporting and investigation,and training and supervision.Safety (or accidents) can be understood as an outcome of the quality of the implementation and monitoring of these integrated activities and processes (Le Coze,2O13).In general,a safety management system approach focuses on three main aspects:physical workplace, people,and organization issues (Makin and Winder, 2Oo8; Zou and Sunindijo, 2Ol5). The links between computer vision and SMS can be discussed based on these three aspects.

# 4.1.1． Safe workplace

One purpose of SMS is to create a safe workplace for workers by identifying hazards,evaluating and controlling risks.Current hazard identification practices in the construction industry are largely paperbased, manual, and inefficient (Zhang et al., 2O15a). Research has suggested that a large proportion of safety hazards remain unrecognized and unmanaged in complex and dynamic construction environments (Carter and Smith，2006;Jeelani et al.，2016). Past studies have demonstrated that computer vision can be applied to support hazard identification, such as Kim et al. (2019a) and Kim et al. (2015). To be useful in practice,a vision-based hazard identification system must have a satisfactory level of comprehensiveness and correctness.First,it is crucial for the system to identify most,if not all,hazards.To achieve this,a comprehensive hazard profile and knowledge base need to be developed.Human experts recognize hazards by utilizing their knowledge and experience.Such a knowledge base needs to be generalized and formalized so that the computer system can understand and apply it to different scenarios and situations.Note that hazard identification is more than common sense,because hazards can be created and emerged by spatial and temporal dynamics between construction site objects (Sacks et al., 2Oo9). Therefore,it is inadequate to define and model a hazard only by its source.As construction is dynamic in nature,the mechanism for a hazard to take place needs to be modeled and formalized.An important assumption can be made that the nature of the hazard is closely associated with spatial and temporal relationships between building elements,materials,temporary equipment and tools, operations,and human workspace.By developing such a spatial and temporal model,a hazard can be re-defined using geometric,spatial,and temporal features,and specific patterns could be identified to distinguish the hazard from others.

Once a formal hazard model is integrated into a vision-based system, it is essential that the system understands the‘meaning"of the whole site scene.Being able to recognize all objects and actions does not necessarily enable the system to achieve a higher level of scene understanding.Froma health and safety perspective,scene understanding involves the following main hierarchical functions:

(1） Understand what the objects are (including humans);   
(2) Understand their roles and relationships;   
(3) Understand their actions;   
(4) Understand the interactions between their actions;   
(5) Understand the activities,scenarios,or work packages they participate in;   
(6) Understand the interactions between different activities,scenarios,or work packages.

This higher level of scene understanding can generate richer information that can drive more powerful reasoning based on the formal hazard model, which improves the system's capability to identify unexpected hazards and unknown potential hazard sets. Once hazards are identified,safety risk evaluation can be performed based on rules and/or knowledge models.

# 4.1.2. Safe people

The key concept that links computer vision with the strategy is “situational awareness (SA)".SAalso refers to“the ability ofmaintaining an appropriate picture of situations to perform safe operations” (Le Coze, 2016). Construction is highly dynamic in nature,and it is beyond even experienced workers'ability to identifyall hazards present on site.Asa result, there are often discrepancies between the human operators' (i.e., workers and managers) understanding of system status and actual system status.Endsley developed a model of situational awareness (Endsley,1995), in which SA is defined at three ascending levels,perception, comprehension,and projection:

·Level 1:Perception，the perception of the elements in the environment, ·Level 2: Comprehension, comprehension of the current situation, ·Level 3: Projection, prediction of future status.

As illustrated in Fig.3,there exists a correspondence between the three-level of SA and the three levels of computer vision development proposed earlier in Section 2.3.

On the left-hand side,developing and maintaining situation awareness requires site personnel to constantly perceive the dynamic site environment,understand the safety impacts,and predict the future hazard profile.Note that Level 1 SA requires high attentional demands and a mental model that directs attention;Levels 2 and 3 SA are developed based on valid safety knowledge that can interpret the information obtained at Level 1.Given the linkage between goals and mental models (Endsley, 2O15),it is likely that workers ignore some safety-related information when they are under production pressure.In addition, it is challenging for workers, especially inexperienced novices, to obtain a quick and reliable understanding of safety impacts on site. It is even difficult for experienced workers to understand and predict the interactions between different objects and activities.As a result,it is unlikely the workers are able to develop and maintaina high level of SA on their own.

There is a significant potential for a vision-based system to reduce the cognitive burden and improve workers’SA at all three levels. Computer vision,combined with other information technologies (e.g., wearable technologies and wireless sensors),is capable of switching workers'information processing fashion.Without information technologies,workers'information processing is largely goal-driven and topdown,that is,a worker's goals direct his/her attention to the site environment.Due to the goal conflicts (e.g.,production vs safety),goaldriven and top-down information processing and decision making can deactivate safety-oriented goals and mental models.By providing timely cues,hazard information,assessment,and prediction,vision-based systems are able to switch the fashion to bottom-up and data-driven information processing. This can considerably help workers develop and maintain SA.

# 4.1.3. Safe organization

Vision-based safety management systems can help build a learning organization.Efforts can be made to create video and image databases of unsafe behavior and incidents.Computer vision techniques can be applied to annotate accident-related videos and images.Information retrieval applications can be developed to facilitate the retrieval of relevant information for safety training,education,and planning.Datadriven accident classification and analysis are not new to safety research (Goh and Ubeynarayana, 2O17; Tixier etal., 2016). Nevertheless, visionbased accident classification and analysis is still in its infancy.In the long term,once the database reaches a suitable size,machine learning algorithms could be applied for useful and legitimate accident classification and prediction.This can significantly help construction companies become true learning organizations if accident-related sensitivity and bureaucracy can be well managed.

# 4.2.Vision-based behavior-based safety (BBS) program

In the evolution of safety theories over the past decades,understanding and managing safety behavior has been an important and popular research topic.Promoting safe behavior is a crucial factor in safety(Guo et al., 2Ol6a). For instance,BBS has received significant attention from researchers since the 197O s.In general,BBS involves a circle of goal setting，manual observation， fedback,and training. Different theories (e.g.,reinforcement theory and goal-setting theory) may be integrated into different BBS programs (Guo et al., 2O18). The main limitation of BBS programs is that it relies on manual observation and analysis,which is subjective,laborious,and ineficient.In addition, the scope of human observation is limited and therefore a big picture is often lost. This has significantly impeded the adoption of BBS in the construction industry.

Computer vision has considerable potential to improve efficiency in observation,and thus facilitate advanced behavioral analysis.As reviewed in this paper,previous works have proved that computer vision can accurately recognize unhealthy pose and simple actions,such as non-PPE (personal protection equipment) users and unsafe ladder climbing.The major limitation is that they focused on recognizing simple repetitive actions (traveling,standing,and bending).In traditional BBS programs,it is of less interest to record simple gestures and atomic actions like not wearing a hardhat.Many interesting human activities on site are characterized by a complex spatial and temporal composition of objects and actions.For example,one of the unsafe behaviors in a checklist developed fora BBS program is:“The signalman gives a warning signal when the load is lifted or moved and ensures no one is standing under the suspended load”(Guo et al.，2O18). To recognize an unsafe behavior that violates this rule,computer vision must not only recognize involved objects (i.e.,workers,crane,load) in terms of identity,location,movement direction, but more importantly, understand the interactions between these objects.

It is clear that the benefits are limited when only classifying actions based on predefined categories (labeled as‘safe”or “unsafe"） using machine learning. This is because there are too many varieties of conditions characterizing real construction site scenes,and it is difficult and inefficient to identify invariants that characterize a certain action and its dynamics.For example,as indicated by Gong et al. (2011), different action categories can have similar gestures and one action category can have a variety of gestures.In some case,whether an action is safe or not depends on the status of other objects.Thus,similar to vision-based hazard identification,assessing complex activities also requires a knowledge model that can determine if an action is safe or not and a framework that classifies safety behavior by the level of abstraction and complexity.The authors of this paper propose a six-level hierarchical framework of safety behavior based on Edwards etal.'s fivelevel classification system (Edwards et al., 2016),as shown in Table 8. Byusing the hierarchy,unsafe and unhealthy behavior (as well as hazards) can be defined at different levels.Theoretically,observingactions atahigh level of abstraction,like safety compliance and safety participation,could enable an analysis of the correlation with safety culture and safety outcomes.

![](images/a790dbe21dbf88233daad5b0cb185d568d8de0dab94ccc95c2f1d5eb909c60ec.jpg)  
Fig.3.The correspondence between SA and CV.

# 4.3.Vision-based safety culture sensing system

Safety culture has been an active research topic in safety science and management. The concept of safety culture claims that safety culture drives the safety process and the success of a safety management system is determined by behavior-based and human factors (Geller,1994).An important research question can be asked: can computer vision be applied to measure safety culture?

Given that safety culture is a multidimensional concept,which dimensions of the concept can be measured? Cooper (2OoOa,b) proposed a reciprocal safety culture model that contains three interrelated elements:(1) observable safety behaviors,(2) subjective internal psychological features,and (3) objective situational features. Cooper suggested that internal psychological features can be assessed by safety climate questionnaires; safety behaviors can be assessed by observational checklists,and the situational features can be assessed through safety management system audits.Based on the reciprocal safety culture model,internal psychological features could be indirectly measured by measuring items in the safety climate questionnaires.In the construction industry,a number of safety climate measures were developed over the past three decades (Dedobbeleer and Béland,1991; Fang et al., 2006; Guo et al., 2016a; Lingard et al., 2009; Mohamed, 2002). Safety climate can be seen as a subset of safety culture (Zou and Sunindijo,2Ol5). It has been proved to be a useful leading indicator of unsafe behavior and accident (Guo et al., 2016a; Guo et al., 2016b; Zohar, 2010).

Table 8 A hierarchical framework of safety behavior.   

<html><body><table><tr><td colspan="2">Safety behavior level</td><td>Definition</td><td>Examples</td></tr><tr><td>L1</td><td>Pose and gesture</td><td>An atomic observation of the spatial arrangement of a human body at a single temporal instance A temporal series of poses</td><td>· Unhealthy and unsafe ladder climbing posture</td></tr><tr><td>L2</td><td>Action</td><td>sub-action scale A series of gestures which form a contextual event</td><td>·A worker uses the welding face shield during hot work.</td></tr><tr><td>L3</td><td>Human-to- human interaction</td><td>A pairwise action committed by two people (e.g.,workers)</td><td>· Safety coaching between a site supervisor and a worker; · Safety communication</td></tr><tr><td></td><td>Human-to- object interaction</td><td>A pairwise action committed by one individual upon an object</td><td>between two workers. · The operator reverses the vehicle with guidance from the traffic controller.</td></tr><tr><td></td><td>Object-to- object interaction</td><td>(e.g., equipment) Pairwise actions committed by two objects</td><td>·The interactions between excavators and dump trucks during earthmoving</td></tr><tr><td>L4</td><td>Activity</td><td>A collection of action and/or interactions that compound to describe a</td><td>operations ·Roofing activity ·Formwork activity · Scaffolding activity</td></tr><tr><td>L5</td><td>Activity-to- activity interaction</td><td>high-level event A pairwise activity committed by one individual (or group)</td><td>·The interaction between crane lift vs.roofing</td></tr><tr><td>L6</td><td>Safety compliance</td><td>upon another activity Following rules in core safety activities</td><td>·Adhering to safety procedures and carrying out work in a safe manner</td></tr><tr><td></td><td>Safety participation</td><td>Promoting the safety program within the workplace,demonstrating initiative,and putting effort into improving</td><td>· Safety coaching</td></tr></table></body></html>

Table 9 lists safety climate factors and corresponding measurement items that could potentially be measured by computer vision techniques. Safety climate factors,like workers involvement, communication and support,PPE,supportive environment, supervisor's role and workmate's role,appraisal of safety procedure and work risk, risk-taking behavior, supervisory safety leadership,co-workers’actual safety,and social support,could be measured by computer vision if their visual features can be defined and recognized.

Table 9 Safety climate measurement items that could be measured by computer vision.   

<html><body><table><tr><td>Safety climate factors</td><td>Measurement items</td><td>Sources</td></tr><tr><td>Workers involvement</td><td>·Foreman regularly and frequently makes us aware of dangerous work practices and conditions and praises us for safe conduct.</td><td>(Dedobbeleer and Béland, 1991)</td></tr><tr><td>Communication and</td><td>meetings at your present job site? ·Workers are encouraged to support and look out for each</td><td>(Glendon and Litherland, 2001)</td></tr><tr><td>support Personal protective equipment Supportive</td><td>other. ·PPE use if monitored to identify problem areas. · Often remind each other on how</td><td></td></tr><tr><td></td><td>to work safely. ·Always offer help when needed to perform the job safely. ·Endeavor to ensure that individuals are not working by themselves under risky or hazardous conditions.</td><td></td></tr><tr><td>Supervisor&#x27;s and workmate&#x27;s role</td><td>·People who work here often have to take risks when they are at work. ·People here always work safely even when they are not being supervised.</td><td>(Fang et al., 2006)</td></tr><tr><td>Appraisal of safety procedure and work</td><td>· Supervisors seldom check that people here are working safely. ·People here always wear their health and safety protective</td><td></td></tr><tr><td>risk Risk-taking behavior</td><td>equipment when they are supposed to. ·Not all the health and safety procedures/instructions/rules</td><td></td></tr><tr><td>Supervisory safety leadership</td><td>are strictly followed here. ·My supervisor approaches workers during work to discuss</td><td>(Lingard et al., 2009)</td></tr><tr><td></td><td>safety issues. ·My immediate supervisor often</td><td></td></tr><tr><td>Co-workers&#x27;actual</td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>talks to me about health and</td><td></td></tr><tr><td></td><td>safety.</td><td></td></tr><tr><td></td><td>·People here always work safely</td><td></td></tr><tr><td>safety</td><td>even when they are not being</td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>supervised.</td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>·When my supervisor and co-</td><td></td></tr><tr><td>Social support</td><td></td><td></td></tr><tr><td></td><td></td><td>(Guo et al., 2016a)</td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>workers see me working at-risk,</td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>they caution me.</td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>·Supervisor frequently moves</td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td></td><td></td></tr><tr><td></td><td>around inspecting the</td><td></td></tr></table></body></html>

Objects involved in these measurement items include (1) foremen, (2) workers,(3) PPE,and (4) supervisors.As suggested in Table 4,past studies have successfully recognized workers,trades,and PPE.Future efforts can be made to recognize different roles of site personnel,as this can help understand and recognize human actions.Human actions involved in these measurement items include (1） identify dangerous work practices,(2) praise workers,(3) organize job safety meeting,(4) workers support and look after each other,(5) risk-taking,(6)wear PPE, (7) safety rules violations,(8) supervisor discuss safety with workers,(9) work safely,(lO) caution co-workers when they are working unsafely, and(l1） safety inspection by supervisors.Matching these safety behaviors that should be recognized against those human actions that can be recognized (see Table 6) makes it clear that much research effort is needed before computer vision technologies can be applied to measure the safety climate factors.

Compared to these factors with tangible visual features,other safety climate factors,such as management commitment to safety，safety attitude,risk perceptions,and work pressure,are much more difficult to measure. Vision-based psychological feature recognition may benefit from Social Signal Processing (SSP) methods.SSP suggests that social signals (e.g.,nonverbal behavior) are the expression of an individual's attitude towards a particular social situation (Vinciarelli et al., 2O09). It is believed that nonverbal behavior conveys information not only of individuals’ feelings,mental state,and personality but also,during social interactions,of the nature of the social relationship(Vinciarelli et al.,2Oo9).For example, SSP has been applied to determine learners' interest level by sensing and interpreting behavior cues (Gatica-Perez et al., 20o5; Mota and Picard, 2003). Similarly, it is possible to estimate the level of safety motivation and safety leadership on site by sensing and interpreting a useful set of behavioral cues.

# 5．Future research

It is important to recognize that current computer vision applications in construction health and safety management are still limited and primitive.To facilitate computer vision technology development and applications to construction health and safety, we suggest the following future research directions:

# 5.1.Develop and test a behavioral-cues-based safety climate measure

As a “snapshot"of safety culture,safety climate is usually measured through a questionnaire that captures workers’perceptions of safety management. Guldenmund (2Oo7） criticized safety climate questionnaires for being a quick but also‘dirty'instrument,due to the fact that theyare easy to use but include a lot of random‘noise'.A vision-based behavioral approach can be used to supplement safety climate questionnaires.

Safety climate studies in the construction industry have suggested that the same safety climate factor (e.g.,supervisory support) can be measured by using different measurement items.The discussion in Section 4.3 showed that some safety climate factors (e.g., risk perception） are difficult to measure using computer vision, due to a lack of tangible visual cues.To address this problem,a safety climate survey which consists of behaviors and tangible behavioral cues should be developed and tested in terms of reliability and validity.

To this end,low-level visual features of relevant behaviors,as well as social and behavioral cues,need to be identified and linked to high-level safety climate factors,such as management commitment to safety and safety attitude.This effort would involve recognizing group behaviors (e.g.,between supervisor and workers,or between workers).It is a common view of social science that group interactions are more complex than individual behavior (Lehmann-Willenbrock et al.， 2Ol7). More research efforts are needed to capture the group interactions by computer vision for construction health and safety.

The value of linking behavior cues to safety climate lies in the fact that this provides an alternative for a long-term prediction of unsafe behavior and accident. Unlike a black-box machine learning approach, this can provide a more interpretable picture of site safety for managers.

# 5.2.Develop safety behavior datasets

Safety behaviors are often a set of events with different levels of abstraction and complexity, from simple unhealthy pose and gestures to complex social interactions on site.Past efforts to identify unsafe behavior using computer vision have been fragmented,with little consideration fora holistic framework that targets all possible unsafe behaviors. Chaquet et al. (2Ol3) conducted a survey of video datasets for human action and activity recognition.There is a lack of publicly available datasets that are dedicated to safety behavior recognition in the construction industry.The hierarchical framework of safety behavior (Table 8) could be validated and used to classify the level of safety behavior from simple pose to complex interactions and activities. Different datasets should be developed at different levels to allow machine learning models to develop an understanding of safety behaviors that occur on construction sites.Progress at the low-level recognition can facilitate high-level recognition. Meaningful aggregations from actions,via activity,to activity-to-activity interaction,can significantly improve the efficiency and usefulness of vision-and behavior-based safety programs.

In addition to the scope issue, behavior complexity and assessment criteria are key issues to be addressed by future studies.To perform comprehensive health and safety monitoring,a high level of scene understanding is required.Future efforts can be made to obtain a semantic meaning of the construction site scene and explore how rich semantics can improve automatic hazard identification and health and safety monitoring.Future research efforts can also be made to link computer vision with workers’behavior simulation models (e.g.，agent-based safety behavior model (Zhang et al., 2O19)).Data collected by computer vision can be integrated into the models as input for simulation and validation. Such a combination could be a promising research direction towards the predictive analysis of site safety.

# 5.3.Develop a formal hazard model

The identification of safety hazards requires more than common sense.People often show over-confidence and complacency in the hazard identification and management process. Traditional methods (e.g., job safety analysis,safe work method statement,and task analysis) define and identify hazards based on tasks and activities.These methods are most suitable when tasks are well defined.However,they may be ineffective to identify hazards that are emerged from the interactions between objects or between activities.These traditional methods can be complemented by re-defining hazards using the information obtained from computer vision assisted object recognition and tracking,action recognition,and spatiotemporal analysis.More research attention should be paid on teaching the vision-based system to understand the generation mechanism of hazards so that both short-term and long-term prediction can be made. Knowledge engineering tools such as ontology can be developed and utilized to enable semantic representation and reasoning. Once basic data (e.g.,signal,perceptual features,and physical objects and actions) are mapped into appropriate ontologies,the semantic meaning of the real construction site scene would be obtained. Therefore,more powerful reasoning can be performed based on the rich semantics to recognize hazards.

# 5.4.Evaluate the real impacts of vision-based technologies on safety performance

Past research had focused on the development of vision-based systems for site safety.Research that evaluates the real impacts of computer vision on safety performance has been limited.The positive impacts cannot be overestimated and individuals’and organizations’perceptions of the technologies must be taken into account.From a cognitive behavior science perspective,worker behaviors are shaped by their attitudes,beliefs, norms,and values.It remains an open question as to how computer vision affects workers'mental processes and eventually their behavior on site.Another interesting issue is the relationship between information technology (e.g., computer vision) and safety culture.Previous studies have suggested that technologies can penetrate organizational culture (Hill,1988).Although safety culture has its roots in organizational culture,it is not clear that how computer vision technologies impact safety culture in construction projects.

# 6. Conclusions

This paper reviewed the state-of-the-art in computer vision development and applications in the construction industry from a health and safety perspective.It categorizes computer vision studies in the construction industry based ona three-level development framework:Level 1 Detection,recognition,and tracking,Level 2 Assessment,and Level 3 Prediction.The three-level development framework was designed to classify the complexity and difficulty of existing computer vision applications.Results indicated that the majority of past efforts were focused on Level1.A wide range of construction project objects can be recognized and tracked.Recent deep learning techniques have significantly improved recognition and tracking performance.In addition, efforts were made to recognize human and equipment behavior at different complexity levels,from recognizing simple pose to complex interactions and events. However,research that is focused on rcognizing unsafe behavior has been limited.

There are even fewer studies that were aimed at developing visionbased safety assessment and prediction systems.Such a current distribution situation is understandable,considering that there are still a number of unsolved technical issues (e.g.,viewpoints,occlusion,light, etc.) that pose significant challenges at Level 1.An investigation of the theoretical implications of computer vision for health and safety reveals that it has strong links to safety research traditions,including safety management system,behavior-based safety program,and safety culture.

It is clear that computer vision technologies can be applied to enhance current safety management systems by improving the efficiency of hazard identification and lifting the situation awareness of workers. Future research can be made to recognize more safety behaviors so that computer vision techniques can be integrated into behavior-based safety programs to reduce the reliance on manual observation and analysis. Developing vision-based safety culture sensing systems is an interesting research area to explore.Interdisciplinary efforts among social science, behavior science,safety science,and computer vision are needed to measure and monitor safety culture using computer vision. Such a move would significantly impact the digital transformation in construction health and safety management and improve safety performance.The suggested research directions are largely theory-oriented.However,it should be noted that the theoretical challenges involved in the health and safety domain are closely related to technical challenges in the computer vision community.This encourages more collaboration between researchers in these two domains.

# References

Akinci, B., Boukamp,F., Gordon, C., Huber, D.,Lyons, C., Park, K.,20o6. A formalism for utilization of sensor systems and integrated project models for active construction quality control. Automation in Construction 15, 124-138.

and an active zoom camera. Journal of Computing in Civil Engineering 30, 04015033.   
Azar,E.R.,McCabe, B., 2012. Part based model and spatial-temporal reasoning to recognize hydraulic excavators in construction images and videos. Automation in Construction 24, 194-202.   
Bai, Y., Huan, J., Kim, S., 2011. Measuring bridge construction efficiency using the wirelesseal-tievieomonitoringsstem.Jouralof ManagementinEngeeing 28, 120-126.   
Bay,H., Ess, A., Tuytelaars, T., Van Gool, L., 2008. Speeded-up robust features (SURF). Computer Vision and Image Understanding 110, 346-359.   
Bouguet, J.-Y., 2Oo1. Pyramidal implementation of the affine lucas kanade feature tracker description of the algorithm. Intel Corporation 5, 4.   
Brilakis, I., Park, M.-W.,Jog, G.,2011. Automated vision tracking of project related entities. Advanced Engineering Informatics 25, 713-724.   
Bigler,M., Borrmann, A., Ogunmakin, G., Vela,P.A., Teizer, J., 2017. Fusion of photogrammetry and video analysis for productivity assessment of earthwork processes. Computer-Aided Civil and Infrastructure Engineering 32,107-123.   
Carr,P., Sheikh,Y.,Matthews,I., 2012. Monocular object detection using 3d geometric primitives. European Conference on Computer Vision. Springer 864-878.   
Carter, G., Smith, S.D., 2006. Safety hazard identification on construction projects. Journal of Construction Engineering and Management 132, 197-205.   
Chaquet, J.M., Carmona, E.J.,Fernandez-Caballero,A., 2013. Asurvey of video datasets for human action and activity recognition. Computer Vision and Image Understanding 117, 633-659.   
Chen,H.,Luo, X.,Zheng,Z., Ke,J.,2019. A proactive workers'safety risk evaluation framework based on position and posture data fusion. Automation in Construction 98, 275-288.   
Chi,S., Caldas, C.H.,201la.Automated object identification using optical video cameras on construction sites. Computer-Aided Civil and Infrastructure Engineering 26, 368-380.   
Chi, S., Caldas, C.H., 20lb.Image-based safety assessment: automated spatial safetyrisk identification of earthmoving and surface mining activities. Journal of Construction Engineering and Management 138, 341-351.   
Chi, S., Caldas, C.H., Kim, D.Y., 2oo9.A methodology for object identification and tracking in construction based on spatial modeling and image matching techniques. Computer-Aided Civil and Infrastructure Engineering 24,199-211.   
Cooper, M.D., 20oo. Towards a model of safety culture. Safety science 36, 111-136.   
Cooper Ph.D,M.,2ooo.Towards a model of safety culture.Safety science 36,111-136.   
Dai, J.,Li,Y.,He,K,Sun,J.,2016.R-fen: Objectdetection viaregion-based fuly convolutional networks. Advances in neural information processing systems 379-387.   
Dalal,N., Triggs,B.,2oo5.Histograms of oriented gradients for human detection, Computer Vision and Pattern Recognition,2005.CVPR 2005.IEEE Computer Society Conference on. IEEE, pp.886-893.   
Dedobbeleer,N., Beland,F.,1991. A safety climate measure for construction sites. Journal of Safety Research 22, 97-103.   
Dimitrov,A., Golparvar-Fard,M.,2014.Vision-based materialrecognitionforautomated monitoring of construction progress and generating building information modeling from unordered site image collections. Advanced Engineering Informatics 28, 37-49.   
Ding, L., Fang, W., Luo, H.,Love,P.E., Zhong,B.,Ouyang, X.,2018. A deep hyid learning model to detect unsafe behavior: Integrating convolution neural networks and long short-term memory. Automation in Construction 86, 118-124.   
Edwards, M., Deng,J., Xie, X., 2016. From pose to activity: Surveying datasets and introducing CONVERSE. Computer Vision and Image Understanding 144, 73-105.   
Endsley, M.R.,1995. Toward a theory of situation awareness indynamic systems.Human factors 37, 32-64.   
Endsley,M.R. 2015. Situationawareness misconceptions and misunderstandings. Journal of Cognitive Engineering and Decision Making 9,4-32.   
Falagas, M.E., Pitsouni, E.I., Malietzis, G.A.,Pappas, G., 20o8.Comparison of PubMed, Scopus, web of science,and Google scholar: strengths and weaknesses. The FASEB journal 22, 338-342.   
Fang,D.,Chen,Y.,Wong,L.J.J.o.c.e.,management, 2oo6.Safety climate in construction industry: A case study in Hong Kong.132, 573-584.   
Fang, Q.,Li,H.,Luo,X.,Ding,L.,Luo,H.,Li, C., 2018a. Computer vision aided inspection on falling prevention measures for steeplejacks in an aerial environment. Automation in Construction 93, 148-164.   
Fang, Q., Li, H.,Luo, X., Ding,L., Luo, H., Rose,T.M.,An,W., 2018b. Detecting nonhardhat-use by a deep learning method from far-field surveillance videos. Automation in Construction 85,1-9.   
Fang, Q.,Li,H., Luo, X.,Ding, L., Rose, T.M., An, W., Yu, Y., 2018c. A deep learningbased method for detecting non-certified work on construction sites. Advanced Engineering Informatics 35, 56-68.   
Fang, W.,Ding,L.,LuoH,Love,PE.,018d.Falsfromheights: Acomputer viobased approach for safety harness detection. Automation in Construction 91, 53-61.   
Fang,W.,Ding,L., Zhong,B.,Love,P.E.,Luo,H., 2018e. Automateddetection of workers and heavy equipment on construction sites: A convolutional neural network approach. Advanced Engineering Informatics 37, 139-149.   
Farha,Y.A.,Richard, A., Gall,J.,2018.When WillYouDo What? - Anticipating Temporal Occurrences of Activities, The IEEE Conference on Computer Vision and Pattern Recognition (CVPR). Computer Vision Foundation,Salt Lake City, pp. 5343-5352.   
Felzenszwalb,P.F., Girshick, R.B.,McAlester, D.,Ramanan, D.,2009. Object detection with discriminatively trained part-based models. IEE transactions on pattern analysis and machine intelligence 32,1627-1645.   
Fraser,M., Elgamal, A., He, X., Conte, J.P., 2009.Sensor network for structural health monitoring of a highway bridge. Journal of Computing in Civil Engineering 24, 11-24.   
Gatica-Perez,D.,McCowan,L., Zhang,D., Bengio,S.,20o5.Detecting group interestlevel in meetings,Acoustics,Speech,and Signal Processing,2oo5.Proceedings. (ICASSP'05).IEEE International Conference on. IEEE,pp.I/489-I/492 Vol. 481.   
Geller, E.S., 1994. Ten principles for achieving a total safety culture. Professional Safety 39,18.   
Glendon, A.1.,Litherland,D.K.,2o1.Safetyclimate factors, groupdiferencesandfety behaviour in road construction. Safety science 39, 157-188.   
Goh, Y.M.,Guo,B.H, 2018.FPSWizard: Aweb-based CBR-RBR system for supporting the design of active fall protection systems. Automation in Construction 85, 40-50.   
Goh, Y.M., Ubeynarayana, C., 2017. Construction accident narrative classification: an evaluation of text mining techniques.Accident Analysis & Prevention 1O8,122-130.   
Goh, Y.M., Ubeynarayana, C.U., Wong, K.L.X., Guo, B.H., 2018. Factors influencing unsafe behaviors: A supervised learning approach. Acident Analysis & Prevention 118, 77-85.   
Golparvar-Fard, M., Heydarian,A., Niebles,J.C., 2013. Vision-based action recognition of earthmoving equipment using spatio-temporal features and support vector machine classifiers. Advanced Engineering Informatics 27, 652-663.   
Gong, J., Caldas, C.H., 2009.Computer vision-based video interpretation model for automated productivity analysis of construction operations. Journal of Computing in Civil Engineering 24, 252-263.   
Gong, J., Caldas, C.H.,2011. An objectrecognition, tracking,and contextual reasoningbased video interpretation method forrapid productivity analysis of construction operations. Automation in Construction 20, 1211-1226.   
Gong,J., Caldas, C.H., Gordon, C., 20l1.Learningand classifying actions of construction workers and equipment using Bag-of-Video-Feature-Words and Bayesian network models. Advanced Engineering Informatics 25, 771-782.   
Guldenmund, F.W., 2O07. The use of questionnaires in safety culture research-an evaluation. Safety science 45, 723-743.   
Guo,B.H.,Goh,Y.M.,2o17. Ontology for design of active fall protection systems. Automation in Construction.   
Guo, B.H., Goh, Y.M., Wong, K.L.X., 2018. A system dynamics view of a behavior-based safety program in the construction industry. Safety science 104, 202-215.   
Guo, B.H., Yiu, T.W., Gonzalez, V.A., 2015. A system dynamics view of safety management in small construction companies. Journal of Construction Engineering and Project Management 5, 1-6.   
Guo, B.H., Yiu, T.W., Gonzalez, V.A., 2016a. Predicting safety behavior in the construction industry: Development and test of an integrative model. Safety science 84, 1-11.   
Guo, B.H., Yiu, T.W., Gonzalez, V.A., Goh, Y.M., 2016b. Using a Pressure-State-Practice Model to Develop Safety Leading Indicators for Construction Projects. Journal of Construction Engineering and Management 143, 04016092.   
Guo, B.H.W., Yiu, T.W., 2016. Developing Leading Indicators to Monitor the Safety Conditions of Construction Projects. Journal of Management in Engineering 32, 04015016.   
Guo,H.,Scheepbouwer,E.,Yiu,T.,Gonzalez,V.,2017a. Overviewand analysisofdigital technologies for construction safety management. In: Lamb, M. (Ed.), Australasian Universities Building Education Association Conference 2017. Melbourne.   
Guo,H.,Yu,Y.,Skitmore,M.J.A.i.C.,2017b.Visualization technology-based construction safety management:A review.73,135-144.   
Hamledari, H., McCabe, B., Davari, S., 2017. Automated computer vision-based detection of components of under-construction indoor partitions. Automation in Construction 74, 78-94.   
Han, S., Lee, S., 20l3. A vision-based motion capture and recognition framework for behavior-based safety management. Automation in Construction 35, 131-141.   
Han, S., Lee, S., Pena-Mora,F., 2O14. Comparative study of motion features for similarity-based modeling and classification of unsafe actions in construction. Journal of Computing in Civil Engineering 28, A4014005.   
Hill, S., 1988. Technology and organization culture: The human imperative in integrating new technology into organization design. Technology in society 10, 233-253.   
Ibrahim, Y.,Lukins, T.C., Zhang, X., Trucco,E. Kaka, A.,20o9.Towards automated progress assessment of workpackage components in construction projects using computer vision. Advanced Engineering Informatics 23, 93-103.   
Jeelani,1., Albert, A., Gambatese, J.A.,2016.Why do construction hazards remain unrecognized at the work interface? Journal of Construction Engineering and Management 143, 04016128.   
Jin, R., Zou,P.X.W.,Piroozfar,P.,Wood, H., Yang, Y., Yan,L.,Han, Y., 2O19.A science mapping approach based review of construction safety research. Safety science 113, 285-297.   
Kalal, Z., Mikolajczyk, K., Matas,J., 2011. Tracking-learning-detection. IEEE transactions on pattern analysis and machine intelligence 34, 1409-1422.   
Khosrowpour, A., Niebles, J.C., Golparvar-Fard, M., 2014. Vision-based workface assessment using depth images for activity analysis of interior construction operations. Automation in Construction 48, 74-87.   
Kim, D.,Liu, M.,Lee,S., Kamat, V.R.,2019a. Remote proximity monitoring between mobile construction resources using camera-mounted UAVs. Automation in Construction 99, 168-182.   
Kim, H., Ahn, C.R, Engelhaupt,D., Lee,S., 2018a. Applicationof dynamic time warping to the recognition of mixed equipment activities in cycle time measurement. Automation in Construction 87, 225-234.   
Kim,H,Ham,Y.Kim,W.,Park,S.,Kim,H.J.A.iC.9b.Vision-basednonintruive detectors. Automation in Construction 88, 23-30.   
Kim,H., Kim,H,Hong,Y.W., Byun,H,2017. Detecting Construction Equipment Usinga Region-Based Fully Convolutional Network and Transfer Learning. Journal of Computing in Civil Engineering 32, 04017082.   
Kim,H.,Ki,K,i,H5.ssedecttriceyesstig fuzzy inference: Monitoring struck-by accidents with moving objects. Journal of Computing in Civil Engineering 30, 04015075.   
Kim, H., Kim,K., Kim,H., 2016. Data-driven scene parsing method for recognizing construction site objects in the whole image. Automation in Construction 71, 271-282.   
Kim, J., Chi, S. 2017. Adaptive detector and tracker on construction sites using functional integration and online learning. Journal of Computing in Civil Engineering 31, 04017026.   
Kim,J.,hi.ctecoitoarthgeavassdota pattern analysis of visual features and operation cycles. Automation in Construction 104, 255-264.   
Kim, J., Chi,S., Seo,J.,2018b.Interaction analysis for vision-based activity identification of earthmoving excavators and dump trucks. Automation in Construction 87, 297-308.   
Kolar, Z., Chen, H.,Luo, X, 2018. Transfer learning and deep convolutional neural networks for safety guardrail detection in 2D images. Automation in Construction 89,58-70.   
Konstantinou,E., Brilakis,1., 2018. Matching construction workers across views for automated 3D vision tracking on-site. Journal of Construction Engineering and Management 144, 04018061.   
Konstantinou,E., Lasenby, J.,Brilakis,1., 2019.Adaptive computer vision-based 2D tracking of workers in complex environments. Automation in. Construction.   
Koppula, H.S., Saxena, A., 2016. Anticipating Human Activities Using Object Affordances for Reactive Robotic Response. IEEE transactions on pattern analysis and machine intelligence 38, 14-29.   
Kropp,C., Koch,C., Konig,M., 2018.Interior construction state recognition with 4D BIM registered image sequences. Automation in Construction 86, 11-32.   
Lan,T., Chen, T.-C.,Savarese, S.,2014. A hierarchical representation for future action prediction. European Conference on Computer Vision. Springer 689-704.   
Le Coze, J.-C., 2013. Outlines of a sensitising model for industrial safety assessment. Safety science 51, 187-201.   
Le Coze,J.C.,2O16.Vive la diversité!High reliability organisation (HRO)and resilience engineering (RE). Safety science.   
Lee,Y.-J., Park, M.-W., 2019.3D tracking of multiple onsite workers based on stereo vision. Automation in Construction 98, 146-159.   
Lehman-Wilenbrock,N.,Hung,H,Keyton,J,07.Newfrontiersiig dynamic group interactions: Bridging social and computer science. Small group research 48, 519-531.   
LiX.,Yi, W,Chi,H.-L,Wang,X.,Chan,A.P.J.A.i.C.,2018.Acriticalreviewof virtal and augmented reality (VR/AR) applications in construction safety.86,150-162.   
Liang, C.-J., Lundeen, K.M., McGee, W., Menassa, C.C., Lee, S., Kamat, V.R., 2019. A vision-based marker-less pose estimation system for articulated construction robots. Automation in Construction 104, 80-94.   
Lienhart,R.,Maydt,J.,2oo2.An extended set of haar-like features for rapid object detection,Image Processing.20o2.Proceedings. 20o2 International Conference on. IEE, pp. I-I.   
Lingard, H.C.,Cooke,T.,Blismas,N.J.C.m.,economics,2oo9.Group-level safety climate in the Australian construction industry:within-group homogeneity and betweengroup differences in road construction and maintenance.27,419-432.   
Liu,K.,GarFard,J.C,gent5.oourciio activity analysis from jobsite video streams.141,O4015035.   
Lowe,D.G., 1999. Object recognition from local scale-invariant features, 7th International Conference on Computer Vision. Corfu, Greece, pp. 1150-1157.   
Luo,H., Xiong,C.,Fang, W.,Love,P.E., Zhang,B., Ouyang, X., 2018a. Convolutional neural networks: Computer vision-based workforce activity assessment in construction. Automation in Construction 94, 282-289.   
Luo,X.,Li,H.,Cao,D.,DaiF.,Seo,J.,Lee,S.J.J.o.C.iC.E.,2018b.Recognizingdivere construction activities in site images via relevance networks of construction related objects detected by convolutional neural networks.32,04018012.   
Luo, X., Li, H., Cao, D., Yu, Y., Yang, X., Huang, T., 2O18c. Towards efficient and objective work sampling: Recognizing workers’ activities in site surveillance videos with two-stream convolutional networks. Automation in Construction 94, 360-370.   
Luo, X., Li, H., Wang, H., Wu, Z., Dai, F., Cao, D., 2019. Vision-based detection and visualization of dynamic workspaces. Automation in Construction 104, 1-13.   
Makin, A.M., Winder, C., 2oo8. Anew conceptual framework to improve theapplication of occupational health and safety management systems. Safety science 46, 935-948.   
Memarzadeh, M., Golparvar-Fard, M., Niebles, J.C., 2013. Automated 2D detection of construction equipment and workers from site video streams using histograms of oriented gradients and colors. Automation in Construction 32, 24-37.   
Mneymneh, B.E., Abbas, M., Khoury, H., 2018. Vision-Based Framework for Intelligent Monitoring of Hardhat Wearing on Construction Sites. Journal of Computing in Civil Engineering 33, 04018066.   
Mohamed, S., 2oo2. Safety climate in construction site environments. Journal of construction engineering management 128, 375-384.   
Moon, S., Bernold, L.E., 1997. Vision-based interactive path planning for robotic bridge paint removal. Journal of Computing in Civil Engineering 11,113-120.   
Mota,S.,Picard, R.W.,2oo3.Automated posture analysis for detecting learner's interest level, Computer Visionand Pattern Recognition Workshop,2003.CVPRW'03.   
Park,M.-W., Brilakis, I., 2012. Construction worker detection in video frames for initializing vision trackers. Automation in Construction 28,15-25.   
Park,M.-W., Brilakis,I., 2O16. Continuous localization of construction workers via integration of detection and tracking. Automation in Construction 72, 129-142.   
Park, M.-W., Elsafty, N., Zhu, Z., 2015. Hardhat-wearing detection for enhancing on-site safety of construction workers. Journal of Construction Engineering and Management 141, 04015024.   
Park,M.-W., Makhmalbaf, A., Brilakis, I., 2011. Comparative study of vision tracking methods for tracking of construction site resources. Automation in Construction 20, 905-915.   
Ranaweera,K.,Ruwanpura,J.,Fernando, S.J.J.o.C.i.C.E.,20l2.Automated real-time monitoring system to measure shift production of tunnel construction projects. 27, 68-77.   
Ray, S.J., Teizer, J.,20l2. Real-time construction worker posture analysis for ergonomics training. Advanced Engineering Informatics 26, 439-455.   
Ren, S., He, K., Girshick, R. Sun, J., 2015. Faster r-cnn: Towards real-time object detection with region proposal networks. Advances in neural information processing systems 91-99.   
Rezazadeh Azar, E., 2017. Semantic Annotation of Videos from Equipment-Intensive Construction Operations by Shot Recognition and Probabilistic Reasoning. Journal of Computing in Civil Engineering 31, 04017042. Rezazadeh Azar, E.,Dickinson, S.,McCabe,B., 2012. Server-customer interaction tracker: computer vision-based system to estimate dirt-loading cycles. Journal of Construction Engineering and Management 139, 785-794.   
Rezazadeh Azar, E., McCabe, B., 2011. Automated visual recognition of dump trucks in construction videos. Journal of Computing in Civil Engineering 26, 769-781.   
Ross,D.A., Lim, J., Lin, R.-S. Yang, M.-H., 2oo8. Incremental learning for robust visual tracking. International journal of computer vision 77, 125-141. Ryoo,M.S., 2011. Human activity prediction: Early recognition of ongoing activities from streaming videos, Computer Vision (ICCV). In: 2O11 IEEE International Conference on. IEEE, pp.1036-1043.   
Sacks, R., Rozenfeld,O., Rosenfeld, Y., 2009. Spatial and temporal exposure to safety hazards in construction. Journal of Construction Engineering and Management 135, 726-736.   
Seo, J.,Han,S., Lee,S., Kim, H.,2O15. Computer vision techniques for construction safety and health monitoring. Advanced Engineering Informatics 29, 239-251.   
Seo, J., Starbuck, R., Han, S.,Lee, S., Armstrong, T.J., 2014. Motion data-driven biomechanical analysis during construction tasks on sites. Journal of Computing in Civil Engineering 29, B4014005.   
Soltani, M.M., Zhu, Z., Hammad, A., 2016. Automated annotation for visual recognition of construction resources using synthetic images. Automation in Construction 62, 14-23.   
Soltani, M.M., Zhu, Z., Hammad, A., 2018. Framework for Location Data Fusion and Pose Estimation of Excavators Using Stereo Vision. Journal of Computing in Civil Engineering 32, 04018045.   
Son,H., Choi, H., Seong, H., Kim, C.,2019.Detection of construction workers under varying poses and changing background in image sequences via very deep residual networks. Automation in Construction 99, 27-38. Tajeen, H., Zhu, Z., 2O14. Image dataset development for measuring construction equipment recognition performance. Automation in Construction 48, 1-10.   
Teizer, J., 2O15. Status quo and open challenges in vision-based sensing and tracking of temporary resources on infrastructure construction sites. Advanced Engineering Informatics 29, 225-238.   
Teizer,J., Cheng,T.,Fang,Y.,2013.Locationtracking anddata visualizationtechnology to advance construction ironworkers’ education and training in safety and productivity. Automation in Construction 35, 53-68. Teizer,J., Vela,P.A., 2oo9. Personnel tracking on construction sites using video camera. Advanced Engineering Informatics 23, 452-462.   
Tixier, A.J.-P., Hallowell, M.R., Rajagopalan, B., Bowman, D., 2016. Application of machine learning to construction injury prediction. Automation in Construction 69, 102-114.   
Torralba,A.,urpKeanfeatuest procedures for multiclass object detection, Computer Vision and Pattern Recognition,2004. CVPR 2004.Proceedings of the 2004 IEEE Computer Society Conference on. IEEE,pp. II-II.   
Trong,N.P., Nguyen, H., Kazunori, K.,Le Hoai, B., 2017.A Comprehensive Survey on Human Activity Prediction. Springer International Publishing, Cham, pp. 411-45.   
Turkan, Y., Bosche, F., Haas, C.I., Haas, R., 2U12. Toward automated earned value tracking using 3D imaging tools. Journal of Construction Engineering and Management 139, 423-433.   
Vinciarelli, A., Pantic, M., Bourlard, H., 2oo9. Social signal processing: Survey of an emerging domain. Image and vision computing 27, 1743-1759.   
Vrigkas,M., Nikou, C., Kakadiaris, LA., 2015. A review of human activity recognition methods. Frontiers in Robotics and AI 2, 28.   
Wang,X.,Love,P.E., Kim, M.J.,Park, C.-S., Sing, C.-P.,Hou,L.,2013. A conceptual framework for integrating building information modeling with augmented reality. Automation in Construction 34, 37-44.   
Wang, Z., Li, H., Zhang, X., 2O19. Construction waste recycling robot for nails and screws: Computer vision technology and neural network approach. Automation in Construction 97, 220-228.   
Xu, J., Yoon, H.-S., 2019. Vision-based estimation of excavator manipulator pose for automated grading control. Automation in Construction 98,122-131.   
Yan, X., Li, H., Wang, C., Seo, J., Zhang, H., Wang, H., 2017. Development of ergonomic posture recognition technique based on 2D ordinary camera for construction hazard prevention through view-invariant features in 2D skeleton motion. Advanced Engineering Informatics 34, 152-163.   
Yang, J., Arif, O., Vela, P.A., Teizer, J., Shi, Z., 2010. Tracking multiple workers on construction sites using video cameras. Advanced Engineering Informatics 24, 428-434.   
Yang,J., Shi, Z., Wu, Z., 2016. Vision-based action recognition of construction workers using dense trajectories. Advanced Engineering Informatics 30, 327-336.   
Yang,J., Vela,P., Teizer,J., Shi, Z., 2O12. Vision-based tower crane tracking for understanding construction activity. Journal of Computing in Civil Engineering 28, 103-112.   
Yilmaz,A., Javed,O.,Shah, M.,2006. Object tracking: A survey. Acm computing surveys (CSUR) 38, 13.   
Yu, Y., Guo, H., Ding, Q., Li, H., Skitmore, M., 2017. An experimental study of real-time identification of construction workers’ unsafe behaviors. Automation in Construction 82, 193-206.   
Yuan, C.,Li, S., Cai, H., 2016. Vision-based excavator detection and tracking using hybrid kinematic shapes and key nodes. Journal of Computing in Civil Engineering 31, 04016038.   
Zhang, H., Yan, X.,Li, H., 2018. Ergonomic posture recognition using 3D view-invariant features from single ordinary camera. Automation in Construction 94, 1-10.   
Zhang, P.,Li, N., Jiang,.,Fang,D., Anumba, C.J.,2019. Anagent-based modeling approach for understanding the efect of worker-management interactions on construction workers’safety-related behaviors. Automation in Construction 97, 29-43.   
Zhang, S., Boukamp,F., Teizer, J., 2015a. Ontology-based semantic modeling of construction safety knowledge: Towards automated safety planning for job hazard analysis (JHA). Automation in Construction 52, 29-41.   
Zhang, S., Sulankivi, K.,Kiviniemi, M.,Romo,I.,Eastman, C.M., Teizer, J.,2015b. BIMbased fall hazard identification and prevention in construction safety planning. Safety science 72, 31-45.   
Zhang,S., Teizer,J.,Lee,J.-K.,Eastman, C.M., Venugopal,M., 2013. Building information modeling (BIM) and safety: Automatic safety checking of construction models and schedules. Automation in Construction 29, 183-195.   
Zhou, Z., Goh, Y.M.,Li, Q., 2015. Overview and analysis of safety management studies in the construction industry. Safety science 72, 337-350.   
Zhu, Z.,Park, M-W., Koch, C., Soltani, M., Hammad,A.,Davari,K.,2016a. Predicting movements of onsite workers and mobile equipment for enhancing construction site safety. Automation in Construction 68, 95-101.   
Zhu, Z., Ren, X., Chen, Z., 2016b. Visual tracking of construction jobsite workforce and equipment with particle filtering. Journal of Computing in Civil Engineering 30, 04016023.   
Zohar,D., 2O10. Thirty years of safety climate research: Reflections and future directions. Accident Analysis & Prevention 42,1517-1522.   
Zou,J., Kim, H., 2Oo7. Using hue, saturation, and value color space for hydraulic excavator idle time analysis.Journal of Computing in Civil Engineering 21, 238-246.   
Zou, P.X., Lun, P., Cipolla, D., Mohamed, S., 2017a. Cloud-based safety information and communication system in infrastructure construction. Safety science 98, 50-69.   
Zou, P.X., Sunindijo, R.Y., 2O15. Strategic safety management in construction and engineering. John Wiley & Sons.   
Zou, Y., Kiviniemi, A., Jones, S.W., 2017b. A review of risk management through BIM and BIM-related technologies. Safety science 97, 88-98.